/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SwapShiftsChangeRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISwapShiftsChangeRequestCollectionPage;
import com.microsoft.graph.requests.extensions.ISwapShiftsChangeRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.SwapShiftsChangeRequestCollectionPage;
import com.microsoft.graph.requests.extensions.SwapShiftsChangeRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SwapShiftsChangeRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.SwapShiftsChangeRequestRequestBuilder;
import java.util.List;

public class SwapShiftsChangeRequestCollectionRequest
extends BaseCollectionRequest<SwapShiftsChangeRequestCollectionResponse, ISwapShiftsChangeRequestCollectionPage>
implements ISwapShiftsChangeRequestCollectionRequest {
    public SwapShiftsChangeRequestCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SwapShiftsChangeRequestCollectionResponse.class, ISwapShiftsChangeRequestCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISwapShiftsChangeRequestCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SwapShiftsChangeRequestCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISwapShiftsChangeRequestCollectionPage get() throws ClientException {
        SwapShiftsChangeRequestCollectionResponse response = (SwapShiftsChangeRequestCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SwapShiftsChangeRequest newSwapShiftsChangeRequest, ICallback<SwapShiftsChangeRequest> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SwapShiftsChangeRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSwapShiftsChangeRequest, callback);
    }

    @Override
    public SwapShiftsChangeRequest post(SwapShiftsChangeRequest newSwapShiftsChangeRequest) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SwapShiftsChangeRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSwapShiftsChangeRequest);
    }

    @Override
    public ISwapShiftsChangeRequestCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISwapShiftsChangeRequestCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISwapShiftsChangeRequestCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISwapShiftsChangeRequestCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISwapShiftsChangeRequestCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISwapShiftsChangeRequestCollectionPage buildFromResponse(SwapShiftsChangeRequestCollectionResponse response) {
        SwapShiftsChangeRequestCollectionRequestBuilder builder = response.nextLink != null ? new SwapShiftsChangeRequestCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SwapShiftsChangeRequestCollectionPage page = new SwapShiftsChangeRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

