/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsTab;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsTabCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsTabCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamsTabRequestBuilder;
import java.util.List;

public class TeamsTabCollectionRequest
extends BaseCollectionRequest<TeamsTabCollectionResponse, ITeamsTabCollectionPage>
implements ITeamsTabCollectionRequest {
    public TeamsTabCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTabCollectionResponse.class, ITeamsTabCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsTabCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamsTabCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsTabCollectionPage get() throws ClientException {
        TeamsTabCollectionResponse response = (TeamsTabCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsTab newTeamsTab, ICallback<TeamsTab> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsTabRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTeamsTab, callback);
    }

    @Override
    public TeamsTab post(TeamsTab newTeamsTab) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsTabRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTeamsTab);
    }

    @Override
    public ITeamsTabCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamsTabCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsTabCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITeamsTabCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITeamsTabCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITeamsTabCollectionPage buildFromResponse(TeamsTabCollectionResponse response) {
        TeamsTabCollectionRequestBuilder builder = response.nextLink != null ? new TeamsTabCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsTabCollectionPage page = new TeamsTabCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

