/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TimeOffRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITimeOffRequestCollectionPage;
import com.microsoft.graph.requests.extensions.ITimeOffRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.TimeOffRequestCollectionPage;
import com.microsoft.graph.requests.extensions.TimeOffRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TimeOffRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.TimeOffRequestRequestBuilder;
import java.util.List;

public class TimeOffRequestCollectionRequest
extends BaseCollectionRequest<TimeOffRequestCollectionResponse, ITimeOffRequestCollectionPage>
implements ITimeOffRequestCollectionRequest {
    public TimeOffRequestCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TimeOffRequestCollectionResponse.class, ITimeOffRequestCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITimeOffRequestCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TimeOffRequestCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITimeOffRequestCollectionPage get() throws ClientException {
        TimeOffRequestCollectionResponse response = (TimeOffRequestCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TimeOffRequest newTimeOffRequest, ICallback<TimeOffRequest> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TimeOffRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTimeOffRequest, callback);
    }

    @Override
    public TimeOffRequest post(TimeOffRequest newTimeOffRequest) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TimeOffRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTimeOffRequest);
    }

    @Override
    public ITimeOffRequestCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITimeOffRequestCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITimeOffRequestCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITimeOffRequestCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITimeOffRequestCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITimeOffRequestCollectionPage buildFromResponse(TimeOffRequestCollectionResponse response) {
        TimeOffRequestCollectionRequestBuilder builder = response.nextLink != null ? new TimeOffRequestCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TimeOffRequestCollectionPage page = new TimeOffRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

