/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TokenLifetimePolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITokenLifetimePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ITokenLifetimePolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.TokenLifetimePolicyRequestBuilder;
import java.util.List;

public class TokenLifetimePolicyCollectionRequest
extends BaseCollectionRequest<TokenLifetimePolicyCollectionResponse, ITokenLifetimePolicyCollectionPage>
implements ITokenLifetimePolicyCollectionRequest {
    public TokenLifetimePolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenLifetimePolicyCollectionResponse.class, ITokenLifetimePolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITokenLifetimePolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TokenLifetimePolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITokenLifetimePolicyCollectionPage get() throws ClientException {
        TokenLifetimePolicyCollectionResponse response = (TokenLifetimePolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TokenLifetimePolicy newTokenLifetimePolicy, ICallback<TokenLifetimePolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TokenLifetimePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTokenLifetimePolicy, callback);
    }

    @Override
    public TokenLifetimePolicy post(TokenLifetimePolicy newTokenLifetimePolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TokenLifetimePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTokenLifetimePolicy);
    }

    @Override
    public ITokenLifetimePolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITokenLifetimePolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITokenLifetimePolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITokenLifetimePolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITokenLifetimePolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITokenLifetimePolicyCollectionPage buildFromResponse(TokenLifetimePolicyCollectionResponse response) {
        TokenLifetimePolicyCollectionRequestBuilder builder = response.nextLink != null ? new TokenLifetimePolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TokenLifetimePolicyCollectionPage page = new TokenLifetimePolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

