/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookOperationCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookOperationRequestBuilder;
import java.util.List;

public class WorkbookOperationCollectionRequest
extends BaseCollectionRequest<WorkbookOperationCollectionResponse, IWorkbookOperationCollectionPage>
implements IWorkbookOperationCollectionRequest {
    public WorkbookOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookOperationCollectionResponse.class, IWorkbookOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookOperationCollectionPage get() throws ClientException {
        WorkbookOperationCollectionResponse response = (WorkbookOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookOperation newWorkbookOperation, ICallback<WorkbookOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookOperation, callback);
    }

    @Override
    public WorkbookOperation post(WorkbookOperation newWorkbookOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookOperation);
    }

    @Override
    public IWorkbookOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookOperationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookOperationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookOperationCollectionPage buildFromResponse(WorkbookOperationCollectionResponse response) {
        WorkbookOperationCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookOperationCollectionPage page = new WorkbookOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

