/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookTable;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookTableCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookTableCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookTableCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookTableCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookTableCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookTableRequestBuilder;
import java.util.List;

public class WorkbookTableCollectionRequest
extends BaseCollectionRequest<WorkbookTableCollectionResponse, IWorkbookTableCollectionPage>
implements IWorkbookTableCollectionRequest {
    public WorkbookTableCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookTableCollectionResponse.class, IWorkbookTableCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookTableCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookTableCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookTableCollectionPage get() throws ClientException {
        WorkbookTableCollectionResponse response = (WorkbookTableCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookTable newWorkbookTable, ICallback<WorkbookTable> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookTable, callback);
    }

    @Override
    public WorkbookTable post(WorkbookTable newWorkbookTable) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookTable);
    }

    @Override
    public IWorkbookTableCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookTableCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookTableCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookTableCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookTableCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookTableCollectionPage buildFromResponse(WorkbookTableCollectionResponse response) {
        WorkbookTableCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookTableCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookTableCollectionPage page = new WorkbookTableCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

