/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetRequestBuilder;
import java.util.List;

public class WorkbookWorksheetCollectionRequest
extends BaseCollectionRequest<WorkbookWorksheetCollectionResponse, IWorkbookWorksheetCollectionPage>
implements IWorkbookWorksheetCollectionRequest {
    public WorkbookWorksheetCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookWorksheetCollectionResponse.class, IWorkbookWorksheetCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookWorksheetCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WorkbookWorksheetCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookWorksheetCollectionPage get() throws ClientException {
        WorkbookWorksheetCollectionResponse response = (WorkbookWorksheetCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookWorksheet newWorkbookWorksheet, ICallback<WorkbookWorksheet> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookWorksheetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookWorksheet, callback);
    }

    @Override
    public WorkbookWorksheet post(WorkbookWorksheet newWorkbookWorksheet) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookWorksheetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkbookWorksheet);
    }

    @Override
    public IWorkbookWorksheetCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWorkbookWorksheetCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWorkbookWorksheetCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWorkbookWorksheetCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWorkbookWorksheetCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWorkbookWorksheetCollectionPage buildFromResponse(WorkbookWorksheetCollectionResponse response) {
        WorkbookWorksheetCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookWorksheetCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookWorksheetCollectionPage page = new WorkbookWorksheetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

