// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AdministrativeUnit;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.UserWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IApplicationWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.ApplicationWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IServicePrincipalWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.ServicePrincipalWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IOrgContactWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.OrgContactWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IScopedRoleMembershipCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IScopedRoleMembershipRequestBuilder;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ScopedRoleMembershipRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Administrative Unit Request.
 */
public class AdministrativeUnitRequest extends BaseRequest implements IAdministrativeUnitRequest {
	
    /**
     * The request for the AdministrativeUnit
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AdministrativeUnitRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AdministrativeUnit.class);
    }

    /**
     * Gets the AdministrativeUnit from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AdministrativeUnit> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AdministrativeUnit from the service
     *
     * @return the AdministrativeUnit from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AdministrativeUnit get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AdministrativeUnit> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AdministrativeUnit with a source
     *
     * @param sourceAdministrativeUnit the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AdministrativeUnit sourceAdministrativeUnit, final ICallback<? super AdministrativeUnit> callback) {
        send(HttpMethod.PATCH, callback, sourceAdministrativeUnit);
    }

    /**
     * Patches this AdministrativeUnit with a source
     *
     * @param sourceAdministrativeUnit the source object with updates
     * @return the updated AdministrativeUnit
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AdministrativeUnit patch(final AdministrativeUnit sourceAdministrativeUnit) throws ClientException {
        return send(HttpMethod.PATCH, sourceAdministrativeUnit);
    }

    /**
     * Creates a AdministrativeUnit with a new object
     *
     * @param newAdministrativeUnit the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AdministrativeUnit newAdministrativeUnit, final ICallback<? super AdministrativeUnit> callback) {
        send(HttpMethod.POST, callback, newAdministrativeUnit);
    }

    /**
     * Creates a AdministrativeUnit with a new object
     *
     * @param newAdministrativeUnit the new object to create
     * @return the created AdministrativeUnit
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AdministrativeUnit post(final AdministrativeUnit newAdministrativeUnit) throws ClientException {
        return send(HttpMethod.POST, newAdministrativeUnit);
    }

    /**
     * Creates a AdministrativeUnit with a new object
     *
     * @param newAdministrativeUnit the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AdministrativeUnit newAdministrativeUnit, final ICallback<? super AdministrativeUnit> callback) {
        send(HttpMethod.PUT, callback, newAdministrativeUnit);
    }

    /**
     * Creates a AdministrativeUnit with a new object
     *
     * @param newAdministrativeUnit the object to create/update
     * @return the created AdministrativeUnit
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AdministrativeUnit put(final AdministrativeUnit newAdministrativeUnit) throws ClientException {
        return send(HttpMethod.PUT, newAdministrativeUnit);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAdministrativeUnitRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AdministrativeUnitRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAdministrativeUnitRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AdministrativeUnitRequest)this;
     }

}

