// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AgreementFile;
import com.microsoft.graph.models.extensions.AgreementFileLocalization;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionPage;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionResponse;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionRequest;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement File Localization Collection Request.
 */
public class AgreementFileLocalizationCollectionRequest extends BaseCollectionRequest<AgreementFileLocalizationCollectionResponse, IAgreementFileLocalizationCollectionPage> implements IAgreementFileLocalizationCollectionRequest {

    /**
     * The request builder for this collection of AgreementFileLocalization
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementFileLocalizationCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFileLocalizationCollectionResponse.class, IAgreementFileLocalizationCollectionPage.class);
    }

    public void get(final ICallback<? super IAgreementFileLocalizationCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IAgreementFileLocalizationCollectionPage get() throws ClientException {
        final AgreementFileLocalizationCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final AgreementFileLocalization newAgreementFileLocalization, final ICallback<? super AgreementFileLocalization> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new AgreementFileLocalizationRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newAgreementFileLocalization, callback);
    }

    public AgreementFileLocalization post(final AgreementFileLocalization newAgreementFileLocalization) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new AgreementFileLocalizationRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newAgreementFileLocalization);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (AgreementFileLocalizationCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (AgreementFileLocalizationCollectionRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest orderBy(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (AgreementFileLocalizationCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (AgreementFileLocalizationCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value + ""));
        return (AgreementFileLocalizationCollectionRequest)this;
    }

    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest skip(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$skip", value + ""));
        return (AgreementFileLocalizationCollectionRequest)this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    public IAgreementFileLocalizationCollectionRequest skipToken(final String skipToken) {
    	addQueryOption(new QueryOption("$skiptoken", skipToken));
        return (IAgreementFileLocalizationCollectionRequest)this;
    }
    public IAgreementFileLocalizationCollectionPage buildFromResponse(final AgreementFileLocalizationCollectionResponse response) {
        final IAgreementFileLocalizationCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new AgreementFileLocalizationCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final AgreementFileLocalizationCollectionPage page = new AgreementFileLocalizationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
