// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Agreement;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Request.
 */
public class AgreementRequest extends BaseRequest implements IAgreementRequest {
	
    /**
     * The request for the Agreement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Agreement.class);
    }

    /**
     * Gets the Agreement from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super Agreement> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Agreement from the service
     *
     * @return the Agreement from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Agreement get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super Agreement> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Agreement with a source
     *
     * @param sourceAgreement the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Agreement sourceAgreement, final ICallback<? super Agreement> callback) {
        send(HttpMethod.PATCH, callback, sourceAgreement);
    }

    /**
     * Patches this Agreement with a source
     *
     * @param sourceAgreement the source object with updates
     * @return the updated Agreement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Agreement patch(final Agreement sourceAgreement) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreement);
    }

    /**
     * Creates a Agreement with a new object
     *
     * @param newAgreement the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Agreement newAgreement, final ICallback<? super Agreement> callback) {
        send(HttpMethod.POST, callback, newAgreement);
    }

    /**
     * Creates a Agreement with a new object
     *
     * @param newAgreement the new object to create
     * @return the created Agreement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Agreement post(final Agreement newAgreement) throws ClientException {
        return send(HttpMethod.POST, newAgreement);
    }

    /**
     * Creates a Agreement with a new object
     *
     * @param newAgreement the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final Agreement newAgreement, final ICallback<? super Agreement> callback) {
        send(HttpMethod.PUT, callback, newAgreement);
    }

    /**
     * Creates a Agreement with a new object
     *
     * @param newAgreement the object to create/update
     * @return the created Agreement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Agreement put(final Agreement newAgreement) throws ClientException {
        return send(HttpMethod.PUT, newAgreement);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAgreementRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AgreementRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAgreementRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AgreementRequest)this;
     }

}

