// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AgreementFileVersion;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement File Version Request.
 */
public interface IAgreementFileVersionRequest extends IHttpRequest {

    /**
     * Gets the AgreementFileVersion from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AgreementFileVersion> callback);

    /**
     * Gets the AgreementFileVersion from the service
     *
     * @return the AgreementFileVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileVersion get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AgreementFileVersion> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AgreementFileVersion with a source
     *
     * @param sourceAgreementFileVersion the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AgreementFileVersion sourceAgreementFileVersion, final ICallback<? super AgreementFileVersion> callback);

    /**
     * Patches this AgreementFileVersion with a source
     *
     * @param sourceAgreementFileVersion the source object with updates
     * @return the updated AgreementFileVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileVersion patch(final AgreementFileVersion sourceAgreementFileVersion) throws ClientException;

    /**
     * Posts a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AgreementFileVersion newAgreementFileVersion, final ICallback<? super AgreementFileVersion> callback);

    /**
     * Posts a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the new object to create
     * @return the created AgreementFileVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileVersion post(final AgreementFileVersion newAgreementFileVersion) throws ClientException;

    /**
     * Posts a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AgreementFileVersion newAgreementFileVersion, final ICallback<? super AgreementFileVersion> callback);

    /**
     * Posts a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the object to create/update
     * @return the created AgreementFileVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileVersion put(final AgreementFileVersion newAgreementFileVersion) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAgreementFileVersionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAgreementFileVersionRequest expand(final String value);

}

