// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PrintOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Operation Request.
 */
public interface IPrintOperationRequest extends IHttpRequest {

    /**
     * Gets the PrintOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PrintOperation> callback);

    /**
     * Gets the PrintOperation from the service
     *
     * @return the PrintOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PrintOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PrintOperation with a source
     *
     * @param sourcePrintOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PrintOperation sourcePrintOperation, final ICallback<? super PrintOperation> callback);

    /**
     * Patches this PrintOperation with a source
     *
     * @param sourcePrintOperation the source object with updates
     * @return the updated PrintOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintOperation patch(final PrintOperation sourcePrintOperation) throws ClientException;

    /**
     * Posts a PrintOperation with a new object
     *
     * @param newPrintOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PrintOperation newPrintOperation, final ICallback<? super PrintOperation> callback);

    /**
     * Posts a PrintOperation with a new object
     *
     * @param newPrintOperation the new object to create
     * @return the created PrintOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintOperation post(final PrintOperation newPrintOperation) throws ClientException;

    /**
     * Posts a PrintOperation with a new object
     *
     * @param newPrintOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PrintOperation newPrintOperation, final ICallback<? super PrintOperation> callback);

    /**
     * Posts a PrintOperation with a new object
     *
     * @param newPrintOperation the object to create/update
     * @return the created PrintOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintOperation put(final PrintOperation newPrintOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrintOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrintOperationRequest expand(final String value);

}

