// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Print;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Request.
 */
public interface IPrintRequest extends IHttpRequest {

    /**
     * Gets the Print from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Print> callback);

    /**
     * Gets the Print from the service
     *
     * @return the Print from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Print get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Print> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Print with a source
     *
     * @param sourcePrint the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Print sourcePrint, final ICallback<? super Print> callback);

    /**
     * Patches this Print with a source
     *
     * @param sourcePrint the source object with updates
     * @return the updated Print
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Print patch(final Print sourcePrint) throws ClientException;

    /**
     * Posts a Print with a new object
     *
     * @param newPrint the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Print newPrint, final ICallback<? super Print> callback);

    /**
     * Posts a Print with a new object
     *
     * @param newPrint the new object to create
     * @return the created Print
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Print post(final Print newPrint) throws ClientException;

    /**
     * Posts a Print with a new object
     *
     * @param newPrint the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Print newPrint, final ICallback<? super Print> callback);

    /**
     * Posts a Print with a new object
     *
     * @param newPrint the object to create/update
     * @return the created Print
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Print put(final Print newPrint) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrintRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrintRequest expand(final String value);

}

