// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintTaskTrigger;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.PrintTaskTrigger;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Task Trigger With Reference Request.
 */
public interface IPrintTaskTriggerWithReferenceRequest extends IHttpRequest {

    void post(final PrintTaskTrigger newPrintTaskTrigger, final IJsonBackedObject payload, final ICallback<? super PrintTaskTrigger> callback);

    PrintTaskTrigger post(final PrintTaskTrigger newPrintTaskTrigger, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super PrintTaskTrigger> callback);

    PrintTaskTrigger get() throws ClientException;

	void delete(final ICallback<? super PrintTaskTrigger> callback);

	void delete() throws ClientException;

	void patch(final PrintTaskTrigger sourcePrintTaskTrigger, final ICallback<? super PrintTaskTrigger> callback);

	PrintTaskTrigger patch(final PrintTaskTrigger sourcePrintTaskTrigger) throws ClientException;

    IPrintTaskTriggerWithReferenceRequest select(final String value);

    IPrintTaskTriggerWithReferenceRequest expand(final String value);

}
