// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.models.extensions.PrintCertificateSigningRequest;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintConnectorWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Printer With Reference Request.
 */
public interface IPrinterWithReferenceRequest extends IHttpRequest {

    void post(final Printer newPrinter, final IJsonBackedObject payload, final ICallback<? super Printer> callback);

    Printer post(final Printer newPrinter, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super Printer> callback);

    Printer get() throws ClientException;

	void delete(final ICallback<? super Printer> callback);

	void delete() throws ClientException;

	void patch(final Printer sourcePrinter, final ICallback<? super Printer> callback);

	Printer patch(final Printer sourcePrinter) throws ClientException;

    IPrinterWithReferenceRequest select(final String value);

    IPrinterWithReferenceRequest expand(final String value);

}
