// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.INotebookGetNotebookFromWebUrlRequest;
import com.microsoft.graph.requests.extensions.NotebookGetNotebookFromWebUrlRequest;
import com.microsoft.graph.models.extensions.CopyNotebookModel;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Get Notebook From Web Url Request Builder.
 */
public class NotebookGetNotebookFromWebUrlRequestBuilder extends BaseActionRequestBuilder implements INotebookGetNotebookFromWebUrlRequestBuilder {

    /**
     * The request builder for this NotebookGetNotebookFromWebUrl
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param webUrl the webUrl
     */
    public NotebookGetNotebookFromWebUrlRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String webUrl) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("webUrl", webUrl);
    }

    /**
     * Creates the INotebookGetNotebookFromWebUrlRequest
     *
     * @param requestOptions the options for the request
     * @return the INotebookGetNotebookFromWebUrlRequest instance
     */
    public INotebookGetNotebookFromWebUrlRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the INotebookGetNotebookFromWebUrlRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the INotebookGetNotebookFromWebUrlRequest instance
     */
    public INotebookGetNotebookFromWebUrlRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        NotebookGetNotebookFromWebUrlRequest request = new NotebookGetNotebookFromWebUrlRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("webUrl")) {
            request.body.webUrl = getParameter("webUrl");
        }

        return request;
    }
}
