// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OrganizationalBrandingLocalization;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Localization Request.
 */
public class OrganizationalBrandingLocalizationRequest extends BaseRequest implements IOrganizationalBrandingLocalizationRequest {
	
    /**
     * The request for the OrganizationalBrandingLocalization
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationalBrandingLocalizationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrganizationalBrandingLocalization.class);
    }

    /**
     * Gets the OrganizationalBrandingLocalization from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super OrganizationalBrandingLocalization> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OrganizationalBrandingLocalization from the service
     *
     * @return the OrganizationalBrandingLocalization from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingLocalization get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super OrganizationalBrandingLocalization> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OrganizationalBrandingLocalization with a source
     *
     * @param sourceOrganizationalBrandingLocalization the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OrganizationalBrandingLocalization sourceOrganizationalBrandingLocalization, final ICallback<? super OrganizationalBrandingLocalization> callback) {
        send(HttpMethod.PATCH, callback, sourceOrganizationalBrandingLocalization);
    }

    /**
     * Patches this OrganizationalBrandingLocalization with a source
     *
     * @param sourceOrganizationalBrandingLocalization the source object with updates
     * @return the updated OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingLocalization patch(final OrganizationalBrandingLocalization sourceOrganizationalBrandingLocalization) throws ClientException {
        return send(HttpMethod.PATCH, sourceOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization, final ICallback<? super OrganizationalBrandingLocalization> callback) {
        send(HttpMethod.POST, callback, newOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the new object to create
     * @return the created OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingLocalization post(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException {
        return send(HttpMethod.POST, newOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization, final ICallback<? super OrganizationalBrandingLocalization> callback) {
        send(HttpMethod.PUT, callback, newOrganizationalBrandingLocalization);
    }

    /**
     * Creates a OrganizationalBrandingLocalization with a new object
     *
     * @param newOrganizationalBrandingLocalization the object to create/update
     * @return the created OrganizationalBrandingLocalization
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OrganizationalBrandingLocalization put(final OrganizationalBrandingLocalization newOrganizationalBrandingLocalization) throws ClientException {
        return send(HttpMethod.PUT, newOrganizationalBrandingLocalization);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOrganizationalBrandingLocalizationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (OrganizationalBrandingLocalizationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOrganizationalBrandingLocalizationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (OrganizationalBrandingLocalizationRequest)this;
     }

}

