// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintUsageByPrinter;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Usage By Printer Request.
 */
public class PrintUsageByPrinterRequest extends BaseRequest implements IPrintUsageByPrinterRequest {
	
    /**
     * The request for the PrintUsageByPrinter
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintUsageByPrinterRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsageByPrinter.class);
    }

    /**
     * Gets the PrintUsageByPrinter from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super PrintUsageByPrinter> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the PrintUsageByPrinter from the service
     *
     * @return the PrintUsageByPrinter from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsageByPrinter get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super PrintUsageByPrinter> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintUsageByPrinter with a source
     *
     * @param sourcePrintUsageByPrinter the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final PrintUsageByPrinter sourcePrintUsageByPrinter, final ICallback<? super PrintUsageByPrinter> callback) {
        send(HttpMethod.PATCH, callback, sourcePrintUsageByPrinter);
    }

    /**
     * Patches this PrintUsageByPrinter with a source
     *
     * @param sourcePrintUsageByPrinter the source object with updates
     * @return the updated PrintUsageByPrinter
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsageByPrinter patch(final PrintUsageByPrinter sourcePrintUsageByPrinter) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final PrintUsageByPrinter newPrintUsageByPrinter, final ICallback<? super PrintUsageByPrinter> callback) {
        send(HttpMethod.POST, callback, newPrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the new object to create
     * @return the created PrintUsageByPrinter
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsageByPrinter post(final PrintUsageByPrinter newPrintUsageByPrinter) throws ClientException {
        return send(HttpMethod.POST, newPrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final PrintUsageByPrinter newPrintUsageByPrinter, final ICallback<? super PrintUsageByPrinter> callback) {
        send(HttpMethod.PUT, callback, newPrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the object to create/update
     * @return the created PrintUsageByPrinter
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public PrintUsageByPrinter put(final PrintUsageByPrinter newPrintUsageByPrinter) throws ClientException {
        return send(HttpMethod.PUT, newPrintUsageByPrinter);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPrintUsageByPrinterRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PrintUsageByPrinterRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPrintUsageByPrinterRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PrintUsageByPrinterRequest)this;
     }

}

