// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Print;
import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.models.extensions.PrintCertificateSigningRequest;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IPrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterCollectionRequest;
import com.microsoft.graph.requests.extensions.IPrinterCreateRequestBuilder;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Collection Request Builder.
 */
public class PrinterCollectionRequestBuilder extends BaseRequestBuilder implements IPrinterCollectionRequestBuilder {

    /**
     * The request builder for this collection of Print
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IPrinterCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IPrinterCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new PrinterCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IPrinterRequestBuilder byId(final String id) {
        return new PrinterRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }



    public IPrinterCreateRequestBuilder create(final String displayName, final String manufacturer, final String model, final String physicalDeviceId, final Boolean hasPhysicalDevice, final PrintCertificateSigningRequest certificateSigningRequest, final String connectorId) {
        return new PrinterCreateRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.create"), getClient(), null, displayName, manufacturer, model, physicalDeviceId, hasPhysicalDevice, certificateSigningRequest, connectorId);
    }
}
