// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.models.extensions.PrintCertificateSigningRequest;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintConnectorWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintConnectorWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterShareWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Request Builder.
 */
public class PrinterRequestBuilder extends BaseRequestBuilder implements IPrinterRequestBuilder {

    /**
     * The request builder for the Printer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IPrinterRequest instance
     */
    public IPrinterRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IPrinterRequest instance
     */
    public IPrinterRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.PrinterRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IPrintJobCollectionRequestBuilder jobs() {
        return new PrintJobCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("jobs"), getClient(), null);
    }

    public IPrintJobRequestBuilder jobs(final String id) {
        return new PrintJobRequestBuilder(getRequestUrlWithAdditionalSegment("jobs") + "/" + id, getClient(), null);
    }
    public IPrintConnectorCollectionWithReferencesRequestBuilder connectors() {
        return new PrintConnectorCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("connectors"), getClient(), null);
    }

    public IPrintConnectorWithReferenceRequestBuilder connectors(final String id) {
        return new PrintConnectorWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("connectors") + "/" + id, getClient(), null);
    }
    public IPrinterShareCollectionWithReferencesRequestBuilder shares() {
        return new PrinterShareCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("shares"), getClient(), null);
    }

    public IPrinterShareWithReferenceRequestBuilder shares(final String id) {
        return new PrinterShareWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("shares") + "/" + id, getClient(), null);
    }
    public IPrintTaskTriggerCollectionRequestBuilder taskTriggers() {
        return new PrintTaskTriggerCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskTriggers"), getClient(), null);
    }

    public IPrintTaskTriggerRequestBuilder taskTriggers(final String id) {
        return new PrintTaskTriggerRequestBuilder(getRequestUrlWithAdditionalSegment("taskTriggers") + "/" + id, getClient(), null);
    }

    public IPrinterRestoreFactoryDefaultsRequestBuilder restoreFactoryDefaults() {
        return new PrinterRestoreFactoryDefaultsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.restoreFactoryDefaults"), getClient(), null);
    }
}
