/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Agreement;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AgreementCollectionPage;
import com.microsoft.graph.requests.extensions.AgreementCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementCollectionResponse;
import com.microsoft.graph.requests.extensions.AgreementRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementCollectionPage;
import com.microsoft.graph.requests.extensions.IAgreementCollectionRequest;
import java.util.List;

public class AgreementCollectionRequest
extends BaseCollectionRequest<AgreementCollectionResponse, IAgreementCollectionPage>
implements IAgreementCollectionRequest {
    public AgreementCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementCollectionResponse.class, IAgreementCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAgreementCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AgreementCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAgreementCollectionPage get() throws ClientException {
        AgreementCollectionResponse response = (AgreementCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Agreement newAgreement, ICallback<? super Agreement> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AgreementRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreement, callback);
    }

    @Override
    public Agreement post(Agreement newAgreement) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AgreementRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAgreement);
    }

    @Override
    public IAgreementCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAgreementCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAgreementCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAgreementCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAgreementCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAgreementCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAgreementCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAgreementCollectionPage buildFromResponse(AgreementCollectionResponse response) {
        AgreementCollectionRequestBuilder builder = response.nextLink != null ? new AgreementCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AgreementCollectionPage page = new AgreementCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

