/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ApplicationTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IApplicationTemplateRequest;
import java.util.List;

public class ApplicationTemplateRequest
extends BaseRequest
implements IApplicationTemplateRequest {
    public ApplicationTemplateRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationTemplate.class);
    }

    @Override
    public void get(ICallback<? super ApplicationTemplate> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ApplicationTemplate get() throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super ApplicationTemplate> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ApplicationTemplate sourceApplicationTemplate, ICallback<? super ApplicationTemplate> callback) {
        this.send(HttpMethod.PATCH, callback, sourceApplicationTemplate);
    }

    @Override
    public ApplicationTemplate patch(ApplicationTemplate sourceApplicationTemplate) throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.PATCH, sourceApplicationTemplate);
    }

    @Override
    public void post(ApplicationTemplate newApplicationTemplate, ICallback<? super ApplicationTemplate> callback) {
        this.send(HttpMethod.POST, callback, newApplicationTemplate);
    }

    @Override
    public ApplicationTemplate post(ApplicationTemplate newApplicationTemplate) throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.POST, newApplicationTemplate);
    }

    @Override
    public void put(ApplicationTemplate newApplicationTemplate, ICallback<? super ApplicationTemplate> callback) {
        this.send(HttpMethod.PUT, callback, newApplicationTemplate);
    }

    @Override
    public ApplicationTemplate put(ApplicationTemplate newApplicationTemplate) throws ClientException {
        return (ApplicationTemplate)this.send(HttpMethod.PUT, newApplicationTemplate);
    }

    @Override
    public IApplicationTemplateRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationTemplateRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

