/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationUserStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceConfigurationUserStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationUserStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationUserStatusCollectionRequest;
import java.util.List;

public class DeviceConfigurationUserStatusCollectionRequest
extends BaseCollectionRequest<DeviceConfigurationUserStatusCollectionResponse, IDeviceConfigurationUserStatusCollectionPage>
implements IDeviceConfigurationUserStatusCollectionRequest {
    public DeviceConfigurationUserStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationUserStatusCollectionResponse.class, IDeviceConfigurationUserStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceConfigurationUserStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceConfigurationUserStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionPage get() throws ClientException {
        DeviceConfigurationUserStatusCollectionResponse response = (DeviceConfigurationUserStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationUserStatus newDeviceConfigurationUserStatus, ICallback<? super DeviceConfigurationUserStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationUserStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceConfigurationUserStatus, callback);
    }

    @Override
    public DeviceConfigurationUserStatus post(DeviceConfigurationUserStatus newDeviceConfigurationUserStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationUserStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceConfigurationUserStatus);
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceConfigurationUserStatusCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceConfigurationUserStatusCollectionPage buildFromResponse(DeviceConfigurationUserStatusCollectionResponse response) {
        DeviceConfigurationUserStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationUserStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationUserStatusCollectionPage page = new DeviceConfigurationUserStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

