/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Printer;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrinterCollectionPage;
import com.microsoft.graph.requests.extensions.IPrinterCollectionRequest;
import com.microsoft.graph.requests.extensions.PrinterCollectionPage;
import com.microsoft.graph.requests.extensions.PrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterCollectionResponse;
import com.microsoft.graph.requests.extensions.PrinterRequestBuilder;
import java.util.List;

public class PrinterCollectionRequest
extends BaseCollectionRequest<PrinterCollectionResponse, IPrinterCollectionPage>
implements IPrinterCollectionRequest {
    public PrinterCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterCollectionResponse.class, IPrinterCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrinterCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrinterCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrinterCollectionPage get() throws ClientException {
        PrinterCollectionResponse response = (PrinterCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Printer newPrinter, ICallback<? super Printer> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrinterRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrinter, callback);
    }

    @Override
    public Printer post(Printer newPrinter) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrinterRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrinter);
    }

    @Override
    public IPrinterCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrinterCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrinterCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrinterCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrinterCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrinterCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrinterCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrinterCollectionPage buildFromResponse(PrinterCollectionResponse response) {
        PrinterCollectionRequestBuilder builder = response.nextLink != null ? new PrinterCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrinterCollectionPage page = new PrinterCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

