/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionPage;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionResponse;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.PrinterShareCollectionWithReferencesRequestBuilder;
import java.util.List;

public class PrinterShareCollectionWithReferencesRequest
extends BaseCollectionRequest<PrinterShareCollectionResponse, IPrinterShareCollectionPage>
implements IPrinterShareCollectionWithReferencesRequest {
    public PrinterShareCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterShareCollectionResponse.class, IPrinterShareCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrinterShareCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrinterShareCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrinterShareCollectionWithReferencesPage get() throws ClientException {
        PrinterShareCollectionResponse response = (PrinterShareCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IPrinterShareCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IPrinterShareCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IPrinterShareCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrinterShareCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IPrinterShareCollectionWithReferencesPage buildFromResponse(PrinterShareCollectionResponse response) {
        PrinterShareCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new PrinterShareCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrinterShareCollectionWithReferencesPage page = new PrinterShareCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

