// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.requests.extensions;
import com.microsoft.graph.callrecords.models.extensions.Segment;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Segment Request.
 */
public interface ISegmentRequest extends IHttpRequest {

    /**
     * Gets the Segment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Segment> callback);

    /**
     * Gets the Segment from the service
     *
     * @return the Segment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Segment get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Segment> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Segment with a source
     *
     * @param sourceSegment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Segment sourceSegment, final ICallback<Segment> callback);

    /**
     * Patches this Segment with a source
     *
     * @param sourceSegment the source object with updates
     * @return the updated Segment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Segment patch(final Segment sourceSegment) throws ClientException;

    /**
     * Posts a Segment with a new object
     *
     * @param newSegment the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Segment newSegment, final ICallback<Segment> callback);

    /**
     * Posts a Segment with a new object
     *
     * @param newSegment the new object to create
     * @return the created Segment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Segment post(final Segment newSegment) throws ClientException;

    /**
     * Posts a Segment with a new object
     *
     * @param newSegment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Segment newSegment, final ICallback<Segment> callback);

    /**
     * Posts a Segment with a new object
     *
     * @param newSegment the object to create/update
     * @return the created Segment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Segment put(final Segment newSegment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISegmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISegmentRequest expand(final String value);

}

