// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.InferenceClassificationOverride;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionResponse;
import com.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Inference Classification.
 */
public class InferenceClassification extends Entity implements IJsonBackedObject {


    /**
     * The Overrides.
     * A set of overrides for a user to always classify messages from specific senders in certain ways: focused, or other. Read-only. Nullable.
     */
    @SerializedName("overrides")
    @Expose
    public InferenceClassificationOverrideCollectionPage overrides;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("overrides")) {
            final InferenceClassificationOverrideCollectionResponse response = new InferenceClassificationOverrideCollectionResponse();
            if (json.has("overrides@odata.nextLink")) {
                response.nextLink = json.get("overrides@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("overrides").toString(), JsonObject[].class);
            final InferenceClassificationOverride[] array = new InferenceClassificationOverride[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), InferenceClassificationOverride.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            overrides = new InferenceClassificationOverrideCollectionPage(response, null);
        }
    }
}
