// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.PermissionGrantConditionSet;
import com.microsoft.graph.models.extensions.PolicyBase;
import com.microsoft.graph.requests.extensions.PermissionGrantConditionSetCollectionResponse;
import com.microsoft.graph.requests.extensions.PermissionGrantConditionSetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Permission Grant Policy.
 */
public class PermissionGrantPolicy extends PolicyBase implements IJsonBackedObject {


    /**
     * The Excludes.
     * 
     */
    @SerializedName("excludes")
    @Expose
    public PermissionGrantConditionSetCollectionPage excludes;

    /**
     * The Includes.
     * 
     */
    @SerializedName("includes")
    @Expose
    public PermissionGrantConditionSetCollectionPage includes;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("excludes")) {
            final PermissionGrantConditionSetCollectionResponse response = new PermissionGrantConditionSetCollectionResponse();
            if (json.has("excludes@odata.nextLink")) {
                response.nextLink = json.get("excludes@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("excludes").toString(), JsonObject[].class);
            final PermissionGrantConditionSet[] array = new PermissionGrantConditionSet[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), PermissionGrantConditionSet.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            excludes = new PermissionGrantConditionSetCollectionPage(response, null);
        }

        if (json.has("includes")) {
            final PermissionGrantConditionSetCollectionResponse response = new PermissionGrantConditionSetCollectionResponse();
            if (json.has("includes@odata.nextLink")) {
                response.nextLink = json.get("includes@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("includes").toString(), JsonObject[].class);
            final PermissionGrantConditionSet[] array = new PermissionGrantConditionSet[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), PermissionGrantConditionSet.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            includes = new PermissionGrantConditionSetCollectionPage(response, null);
        }
    }
}
