// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.WorkbookIcon;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Filter Criteria.
 */
public class WorkbookFilterCriteria implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Color.
     * 
     */
    @SerializedName("color")
    @Expose
    public String color;

    /**
     * The Criterion1.
     * 
     */
    @SerializedName("criterion1")
    @Expose
    public String criterion1;

    /**
     * The Criterion2.
     * 
     */
    @SerializedName("criterion2")
    @Expose
    public String criterion2;

    /**
     * The Dynamic Criteria.
     * 
     */
    @SerializedName("dynamicCriteria")
    @Expose
    public String dynamicCriteria;

    /**
     * The Filter On.
     * 
     */
    @SerializedName("filterOn")
    @Expose
    public String filterOn;

    /**
     * The Icon.
     * 
     */
    @SerializedName("icon")
    @Expose
    public WorkbookIcon icon;

    /**
     * The Operator.
     * 
     */
    @SerializedName("operator")
    @Expose
    public String operator;

    /**
     * The Values.
     * 
     */
    @SerializedName("values")
    @Expose
    public com.google.gson.JsonElement values;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
