// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.ItemReference;
import com.microsoft.graph.models.extensions.DriveItemUploadableProperties;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.models.extensions.Permission;
import com.microsoft.graph.models.extensions.DriveRecipient;
import com.microsoft.graph.models.extensions.ItemPreviewInfo;
import com.microsoft.graph.models.extensions.ItemActivityStat;
import com.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IPermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPermissionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISubscriptionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISubscriptionRequestBuilder;
import com.microsoft.graph.requests.extensions.SubscriptionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SubscriptionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThumbnailSetRequestBuilder;
import com.microsoft.graph.requests.extensions.ThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThumbnailSetRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookRequestBuilder;
import com.microsoft.graph.requests.extensions.IItemAnalyticsRequestBuilder;
import com.microsoft.graph.requests.extensions.ItemAnalyticsRequestBuilder;
import com.microsoft.graph.requests.extensions.IListItemRequestBuilder;
import com.microsoft.graph.requests.extensions.ListItemRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Request.
 */
public class DriveItemRequest extends BaseRequest implements IDriveItemRequest {
	
    /**
     * The request for the DriveItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DriveItemRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItem.class);
    }

    /**
     * Gets the DriveItem from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<DriveItem> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DriveItem from the service
     *
     * @return the DriveItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DriveItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<DriveItem> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DriveItem with a source
     *
     * @param sourceDriveItem the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DriveItem sourceDriveItem, final ICallback<DriveItem> callback) {
        send(HttpMethod.PATCH, callback, sourceDriveItem);
    }

    /**
     * Patches this DriveItem with a source
     *
     * @param sourceDriveItem the source object with updates
     * @return the updated DriveItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DriveItem patch(final DriveItem sourceDriveItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceDriveItem);
    }

    /**
     * Creates a DriveItem with a new object
     *
     * @param newDriveItem the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DriveItem newDriveItem, final ICallback<DriveItem> callback) {
        send(HttpMethod.POST, callback, newDriveItem);
    }

    /**
     * Creates a DriveItem with a new object
     *
     * @param newDriveItem the new object to create
     * @return the created DriveItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DriveItem post(final DriveItem newDriveItem) throws ClientException {
        return send(HttpMethod.POST, newDriveItem);
    }

    /**
     * Creates a DriveItem with a new object
     *
     * @param newDriveItem the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final DriveItem newDriveItem, final ICallback<DriveItem> callback) {
        send(HttpMethod.PUT, callback, newDriveItem);
    }

    /**
     * Creates a DriveItem with a new object
     *
     * @param newDriveItem the object to create/update
     * @return the created DriveItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DriveItem put(final DriveItem newDriveItem) throws ClientException {
        return send(HttpMethod.PUT, newDriveItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDriveItemRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (DriveItemRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDriveItemRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (DriveItemRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IDriveItemRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (DriveItemRequest)this;
     }

}

