// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Contact;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Contact Request.
 */
public interface IContactRequest extends IHttpRequest {

    /**
     * Gets the Contact from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Contact> callback);

    /**
     * Gets the Contact from the service
     *
     * @return the Contact from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Contact get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Contact> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Contact with a source
     *
     * @param sourceContact the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Contact sourceContact, final ICallback<Contact> callback);

    /**
     * Patches this Contact with a source
     *
     * @param sourceContact the source object with updates
     * @return the updated Contact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Contact patch(final Contact sourceContact) throws ClientException;

    /**
     * Posts a Contact with a new object
     *
     * @param newContact the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Contact newContact, final ICallback<Contact> callback);

    /**
     * Posts a Contact with a new object
     *
     * @param newContact the new object to create
     * @return the created Contact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Contact post(final Contact newContact) throws ClientException;

    /**
     * Posts a Contact with a new object
     *
     * @param newContact the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Contact newContact, final ICallback<Contact> callback);

    /**
     * Posts a Contact with a new object
     *
     * @param newContact the object to create/update
     * @return the created Contact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Contact put(final Contact newContact) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IContactRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IContactRequest expand(final String value);

}

