// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DelegatedPermissionClassification;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Delegated Permission Classification Request.
 */
public interface IDelegatedPermissionClassificationRequest extends IHttpRequest {

    /**
     * Gets the DelegatedPermissionClassification from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DelegatedPermissionClassification> callback);

    /**
     * Gets the DelegatedPermissionClassification from the service
     *
     * @return the DelegatedPermissionClassification from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DelegatedPermissionClassification get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DelegatedPermissionClassification> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DelegatedPermissionClassification with a source
     *
     * @param sourceDelegatedPermissionClassification the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DelegatedPermissionClassification sourceDelegatedPermissionClassification, final ICallback<DelegatedPermissionClassification> callback);

    /**
     * Patches this DelegatedPermissionClassification with a source
     *
     * @param sourceDelegatedPermissionClassification the source object with updates
     * @return the updated DelegatedPermissionClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DelegatedPermissionClassification patch(final DelegatedPermissionClassification sourceDelegatedPermissionClassification) throws ClientException;

    /**
     * Posts a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DelegatedPermissionClassification newDelegatedPermissionClassification, final ICallback<DelegatedPermissionClassification> callback);

    /**
     * Posts a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the new object to create
     * @return the created DelegatedPermissionClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DelegatedPermissionClassification post(final DelegatedPermissionClassification newDelegatedPermissionClassification) throws ClientException;

    /**
     * Posts a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DelegatedPermissionClassification newDelegatedPermissionClassification, final ICallback<DelegatedPermissionClassification> callback);

    /**
     * Posts a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the object to create/update
     * @return the created DelegatedPermissionClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DelegatedPermissionClassification put(final DelegatedPermissionClassification newDelegatedPermissionClassification) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDelegatedPermissionClassificationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDelegatedPermissionClassificationRequest expand(final String value);

}

