// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DomainDnsMxRecord;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Domain Dns Mx Record Request.
 */
public interface IDomainDnsMxRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsMxRecord from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DomainDnsMxRecord> callback);

    /**
     * Gets the DomainDnsMxRecord from the service
     *
     * @return the DomainDnsMxRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsMxRecord get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DomainDnsMxRecord> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsMxRecord with a source
     *
     * @param sourceDomainDnsMxRecord the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DomainDnsMxRecord sourceDomainDnsMxRecord, final ICallback<DomainDnsMxRecord> callback);

    /**
     * Patches this DomainDnsMxRecord with a source
     *
     * @param sourceDomainDnsMxRecord the source object with updates
     * @return the updated DomainDnsMxRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsMxRecord patch(final DomainDnsMxRecord sourceDomainDnsMxRecord) throws ClientException;

    /**
     * Posts a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DomainDnsMxRecord newDomainDnsMxRecord, final ICallback<DomainDnsMxRecord> callback);

    /**
     * Posts a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the new object to create
     * @return the created DomainDnsMxRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsMxRecord post(final DomainDnsMxRecord newDomainDnsMxRecord) throws ClientException;

    /**
     * Posts a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DomainDnsMxRecord newDomainDnsMxRecord, final ICallback<DomainDnsMxRecord> callback);

    /**
     * Posts a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the object to create/update
     * @return the created DomainDnsMxRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DomainDnsMxRecord put(final DomainDnsMxRecord newDomainDnsMxRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDomainDnsMxRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDomainDnsMxRecordRequest expand(final String value);

}

