// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ExtensionProperty;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Extension Property Request.
 */
public interface IExtensionPropertyRequest extends IHttpRequest {

    /**
     * Gets the ExtensionProperty from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ExtensionProperty> callback);

    /**
     * Gets the ExtensionProperty from the service
     *
     * @return the ExtensionProperty from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ExtensionProperty get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ExtensionProperty> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ExtensionProperty with a source
     *
     * @param sourceExtensionProperty the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ExtensionProperty sourceExtensionProperty, final ICallback<ExtensionProperty> callback);

    /**
     * Patches this ExtensionProperty with a source
     *
     * @param sourceExtensionProperty the source object with updates
     * @return the updated ExtensionProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ExtensionProperty patch(final ExtensionProperty sourceExtensionProperty) throws ClientException;

    /**
     * Posts a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ExtensionProperty newExtensionProperty, final ICallback<ExtensionProperty> callback);

    /**
     * Posts a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the new object to create
     * @return the created ExtensionProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ExtensionProperty post(final ExtensionProperty newExtensionProperty) throws ClientException;

    /**
     * Posts a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ExtensionProperty newExtensionProperty, final ICallback<ExtensionProperty> callback);

    /**
     * Posts a ExtensionProperty with a new object
     *
     * @param newExtensionProperty the object to create/update
     * @return the created ExtensionProperty
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ExtensionProperty put(final ExtensionProperty newExtensionProperty) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IExtensionPropertyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IExtensionPropertyRequest expand(final String value);

}

