// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ItemAttachment;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Item Attachment Request.
 */
public interface IItemAttachmentRequest extends IHttpRequest {

    /**
     * Gets the ItemAttachment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ItemAttachment> callback);

    /**
     * Gets the ItemAttachment from the service
     *
     * @return the ItemAttachment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ItemAttachment get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ItemAttachment> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ItemAttachment with a source
     *
     * @param sourceItemAttachment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ItemAttachment sourceItemAttachment, final ICallback<ItemAttachment> callback);

    /**
     * Patches this ItemAttachment with a source
     *
     * @param sourceItemAttachment the source object with updates
     * @return the updated ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ItemAttachment patch(final ItemAttachment sourceItemAttachment) throws ClientException;

    /**
     * Posts a ItemAttachment with a new object
     *
     * @param newItemAttachment the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ItemAttachment newItemAttachment, final ICallback<ItemAttachment> callback);

    /**
     * Posts a ItemAttachment with a new object
     *
     * @param newItemAttachment the new object to create
     * @return the created ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ItemAttachment post(final ItemAttachment newItemAttachment) throws ClientException;

    /**
     * Posts a ItemAttachment with a new object
     *
     * @param newItemAttachment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ItemAttachment newItemAttachment, final ICallback<ItemAttachment> callback);

    /**
     * Posts a ItemAttachment with a new object
     *
     * @param newItemAttachment the object to create/update
     * @return the created ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ItemAttachment put(final ItemAttachment newItemAttachment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IItemAttachmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IItemAttachmentRequest expand(final String value);

}

