// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ManagedAppRegistration;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IManagedAppOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IManagedAppOperationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.ManagedAppRegistration;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed App Registration Reference Request.
 */
public interface IManagedAppRegistrationReferenceRequest extends IHttpRequest {

    void delete(final ICallback<ManagedAppRegistration> callback);

    ManagedAppRegistration delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedAppRegistrationReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedAppRegistrationReferenceRequest expand(final String value);

    /**
     * Puts the ManagedAppRegistration
     *
     * @param srcManagedAppRegistration the ManagedAppRegistration to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(ManagedAppRegistration srcManagedAppRegistration, final ICallback<ManagedAppRegistration> callback);

    /**
     * Puts the ManagedAppRegistration
     *
     * @param srcManagedAppRegistration the ManagedAppRegistration to PUT
     * @return the ManagedAppRegistration
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    ManagedAppRegistration put(ManagedAppRegistration srcManagedAppRegistration) throws ClientException;
}
