// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Post;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Post Request.
 */
public interface IPostRequest extends IHttpRequest {

    /**
     * Gets the Post from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Post> callback);

    /**
     * Gets the Post from the service
     *
     * @return the Post from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Post get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Post> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Post with a source
     *
     * @param sourcePost the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Post sourcePost, final ICallback<Post> callback);

    /**
     * Patches this Post with a source
     *
     * @param sourcePost the source object with updates
     * @return the updated Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Post patch(final Post sourcePost) throws ClientException;

    /**
     * Posts a Post with a new object
     *
     * @param newPost the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Post newPost, final ICallback<Post> callback);

    /**
     * Posts a Post with a new object
     *
     * @param newPost the new object to create
     * @return the created Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Post post(final Post newPost) throws ClientException;

    /**
     * Posts a Post with a new object
     *
     * @param newPost the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Post newPost, final ICallback<Post> callback);

    /**
     * Posts a Post with a new object
     *
     * @param newPost the object to create/update
     * @return the created Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Post put(final Post newPost) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPostRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPostRequest expand(final String value);

}

