// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.SecureScoreControlProfile;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Secure Score Control Profile Request.
 */
public interface ISecureScoreControlProfileRequest extends IHttpRequest {

    /**
     * Gets the SecureScoreControlProfile from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<SecureScoreControlProfile> callback);

    /**
     * Gets the SecureScoreControlProfile from the service
     *
     * @return the SecureScoreControlProfile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScoreControlProfile get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<SecureScoreControlProfile> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SecureScoreControlProfile with a source
     *
     * @param sourceSecureScoreControlProfile the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final SecureScoreControlProfile sourceSecureScoreControlProfile, final ICallback<SecureScoreControlProfile> callback);

    /**
     * Patches this SecureScoreControlProfile with a source
     *
     * @param sourceSecureScoreControlProfile the source object with updates
     * @return the updated SecureScoreControlProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScoreControlProfile patch(final SecureScoreControlProfile sourceSecureScoreControlProfile) throws ClientException;

    /**
     * Posts a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final SecureScoreControlProfile newSecureScoreControlProfile, final ICallback<SecureScoreControlProfile> callback);

    /**
     * Posts a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the new object to create
     * @return the created SecureScoreControlProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScoreControlProfile post(final SecureScoreControlProfile newSecureScoreControlProfile) throws ClientException;

    /**
     * Posts a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final SecureScoreControlProfile newSecureScoreControlProfile, final ICallback<SecureScoreControlProfile> callback);

    /**
     * Posts a SecureScoreControlProfile with a new object
     *
     * @param newSecureScoreControlProfile the object to create/update
     * @return the created SecureScoreControlProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScoreControlProfile put(final SecureScoreControlProfile newSecureScoreControlProfile) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISecureScoreControlProfileRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISecureScoreControlProfileRequest expand(final String value);

}

