// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.UserActivity;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.UserActivity;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the User Activity With Reference Request.
 */
public interface IUserActivityWithReferenceRequest extends IHttpRequest {

    void post(final UserActivity newUserActivity, final IJsonBackedObject payload, final ICallback<UserActivity> callback);

    UserActivity post(final UserActivity newUserActivity, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<UserActivity> callback);

    UserActivity get() throws ClientException;

	void delete(final ICallback<UserActivity> callback);

	void delete() throws ClientException;

	void patch(final UserActivity sourceUserActivity, final ICallback<UserActivity> callback);

	UserActivity patch(final UserActivity sourceUserActivity) throws ClientException;

    IUserActivityWithReferenceRequest select(final String value);

    IUserActivityWithReferenceRequest expand(final String value);

}
