// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionAppLearningSummary;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows Information Protection App Learning Summary Request.
 */
public interface IWindowsInformationProtectionAppLearningSummaryRequest extends IHttpRequest {

    /**
     * Gets the WindowsInformationProtectionAppLearningSummary from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WindowsInformationProtectionAppLearningSummary> callback);

    /**
     * Gets the WindowsInformationProtectionAppLearningSummary from the service
     *
     * @return the WindowsInformationProtectionAppLearningSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtectionAppLearningSummary get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WindowsInformationProtectionAppLearningSummary> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WindowsInformationProtectionAppLearningSummary with a source
     *
     * @param sourceWindowsInformationProtectionAppLearningSummary the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WindowsInformationProtectionAppLearningSummary sourceWindowsInformationProtectionAppLearningSummary, final ICallback<WindowsInformationProtectionAppLearningSummary> callback);

    /**
     * Patches this WindowsInformationProtectionAppLearningSummary with a source
     *
     * @param sourceWindowsInformationProtectionAppLearningSummary the source object with updates
     * @return the updated WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtectionAppLearningSummary patch(final WindowsInformationProtectionAppLearningSummary sourceWindowsInformationProtectionAppLearningSummary) throws ClientException;

    /**
     * Posts a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary, final ICallback<WindowsInformationProtectionAppLearningSummary> callback);

    /**
     * Posts a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the new object to create
     * @return the created WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtectionAppLearningSummary post(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException;

    /**
     * Posts a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary, final ICallback<WindowsInformationProtectionAppLearningSummary> callback);

    /**
     * Posts a WindowsInformationProtectionAppLearningSummary with a new object
     *
     * @param newWindowsInformationProtectionAppLearningSummary the object to create/update
     * @return the created WindowsInformationProtectionAppLearningSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsInformationProtectionAppLearningSummary put(final WindowsInformationProtectionAppLearningSummary newWindowsInformationProtectionAppLearningSummary) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindowsInformationProtectionAppLearningSummaryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindowsInformationProtectionAppLearningSummaryRequest expand(final String value);

}

