// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookChartItemAtRequest;

import com.microsoft.graph.http.IRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Item At Request Builder.
 */
public interface IWorkbookChartItemAtRequestBuilder extends IRequestBuilder {

    /**
     * Creates the IWorkbookChartItemAtRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookChartItemAtRequest instance
     */
    IWorkbookChartItemAtRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the IWorkbookChartItemAtRequest with specific options instead of the existing options
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookChartItemAtRequest instance
     */
    IWorkbookChartItemAtRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);

    /**
     * Gets the request builder for WorkbookChartAxes
     *
     * @return the IWorkbookChartAxesRequestBuilder instance
     */
    IWorkbookChartAxesRequestBuilder axes();

    /**
     * Gets the request builder for WorkbookChartDataLabels
     *
     * @return the IWorkbookChartDataLabelsRequestBuilder instance
     */
    IWorkbookChartDataLabelsRequestBuilder dataLabels();

    /**
     * Gets the request builder for WorkbookChartAreaFormat
     *
     * @return the IWorkbookChartAreaFormatRequestBuilder instance
     */
    IWorkbookChartAreaFormatRequestBuilder format();

    /**
     * Gets the request builder for WorkbookChartLegend
     *
     * @return the IWorkbookChartLegendRequestBuilder instance
     */
    IWorkbookChartLegendRequestBuilder legend();

    IWorkbookChartSeriesCollectionRequestBuilder series();

    IWorkbookChartSeriesRequestBuilder series(final String id);

    /**
     * Gets the request builder for WorkbookChartTitle
     *
     * @return the IWorkbookChartTitleRequestBuilder instance
     */
    IWorkbookChartTitleRequestBuilder title();

    /**
     * Gets the request builder for WorkbookWorksheet
     *
     * @return the IWorkbookWorksheetRequestBuilder instance
     */
    IWorkbookWorksheetRequestBuilder worksheet();
}
