// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartLineFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Line Format Request.
 */
public interface IWorkbookChartLineFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartLineFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Gets the WorkbookChartLineFormat from the service
     *
     * @return the WorkbookChartLineFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLineFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartLineFormat with a source
     *
     * @param sourceWorkbookChartLineFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartLineFormat sourceWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Patches this WorkbookChartLineFormat with a source
     *
     * @param sourceWorkbookChartLineFormat the source object with updates
     * @return the updated WorkbookChartLineFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLineFormat patch(final WorkbookChartLineFormat sourceWorkbookChartLineFormat) throws ClientException;

    /**
     * Posts a WorkbookChartLineFormat with a new object
     *
     * @param newWorkbookChartLineFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartLineFormat newWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Posts a WorkbookChartLineFormat with a new object
     *
     * @param newWorkbookChartLineFormat the new object to create
     * @return the created WorkbookChartLineFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLineFormat post(final WorkbookChartLineFormat newWorkbookChartLineFormat) throws ClientException;

    /**
     * Posts a WorkbookChartLineFormat with a new object
     *
     * @param newWorkbookChartLineFormat the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartLineFormat newWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Posts a WorkbookChartLineFormat with a new object
     *
     * @param newWorkbookChartLineFormat the object to create/update
     * @return the created WorkbookChartLineFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLineFormat put(final WorkbookChartLineFormat newWorkbookChartLineFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartLineFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartLineFormatRequest expand(final String value);

}

