// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookTableSort;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Table Sort Request.
 */
public interface IWorkbookTableSortRequest extends IHttpRequest {

    /**
     * Gets the WorkbookTableSort from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookTableSort> callback);

    /**
     * Gets the WorkbookTableSort from the service
     *
     * @return the WorkbookTableSort from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookTableSort get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookTableSort> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookTableSort with a source
     *
     * @param sourceWorkbookTableSort the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookTableSort sourceWorkbookTableSort, final ICallback<WorkbookTableSort> callback);

    /**
     * Patches this WorkbookTableSort with a source
     *
     * @param sourceWorkbookTableSort the source object with updates
     * @return the updated WorkbookTableSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookTableSort patch(final WorkbookTableSort sourceWorkbookTableSort) throws ClientException;

    /**
     * Posts a WorkbookTableSort with a new object
     *
     * @param newWorkbookTableSort the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookTableSort newWorkbookTableSort, final ICallback<WorkbookTableSort> callback);

    /**
     * Posts a WorkbookTableSort with a new object
     *
     * @param newWorkbookTableSort the new object to create
     * @return the created WorkbookTableSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookTableSort post(final WorkbookTableSort newWorkbookTableSort) throws ClientException;

    /**
     * Posts a WorkbookTableSort with a new object
     *
     * @param newWorkbookTableSort the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookTableSort newWorkbookTableSort, final ICallback<WorkbookTableSort> callback);

    /**
     * Posts a WorkbookTableSort with a new object
     *
     * @param newWorkbookTableSort the object to create/update
     * @return the created WorkbookTableSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookTableSort put(final WorkbookTableSort newWorkbookTableSort) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookTableSortRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookTableSortRequest expand(final String value);

}

