// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.IdentityProvider;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Provider Request.
 */
public class IdentityProviderRequest extends BaseRequest implements IIdentityProviderRequest {
	
    /**
     * The request for the IdentityProvider
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProviderRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProvider.class);
    }

    /**
     * Gets the IdentityProvider from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<IdentityProvider> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the IdentityProvider from the service
     *
     * @return the IdentityProvider from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public IdentityProvider get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<IdentityProvider> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityProvider with a source
     *
     * @param sourceIdentityProvider the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final IdentityProvider sourceIdentityProvider, final ICallback<IdentityProvider> callback) {
        send(HttpMethod.PATCH, callback, sourceIdentityProvider);
    }

    /**
     * Patches this IdentityProvider with a source
     *
     * @param sourceIdentityProvider the source object with updates
     * @return the updated IdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public IdentityProvider patch(final IdentityProvider sourceIdentityProvider) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityProvider);
    }

    /**
     * Creates a IdentityProvider with a new object
     *
     * @param newIdentityProvider the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final IdentityProvider newIdentityProvider, final ICallback<IdentityProvider> callback) {
        send(HttpMethod.POST, callback, newIdentityProvider);
    }

    /**
     * Creates a IdentityProvider with a new object
     *
     * @param newIdentityProvider the new object to create
     * @return the created IdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public IdentityProvider post(final IdentityProvider newIdentityProvider) throws ClientException {
        return send(HttpMethod.POST, newIdentityProvider);
    }

    /**
     * Creates a IdentityProvider with a new object
     *
     * @param newIdentityProvider the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final IdentityProvider newIdentityProvider, final ICallback<IdentityProvider> callback) {
        send(HttpMethod.PUT, callback, newIdentityProvider);
    }

    /**
     * Creates a IdentityProvider with a new object
     *
     * @param newIdentityProvider the object to create/update
     * @return the created IdentityProvider
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public IdentityProvider put(final IdentityProvider newIdentityProvider) throws ClientException {
        return send(HttpMethod.PUT, newIdentityProvider);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IIdentityProviderRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (IdentityProviderRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IIdentityProviderRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (IdentityProviderRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IIdentityProviderRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (IdentityProviderRequest)this;
     }

}

