// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.InformationProtection;
import com.microsoft.graph.models.extensions.ThreatAssessmentRequest;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestCollectionPage;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Threat Assessment Request Collection Request.
 */
public class ThreatAssessmentRequestCollectionRequest extends BaseCollectionRequest<ThreatAssessmentRequestCollectionResponse, IThreatAssessmentRequestCollectionPage> implements IThreatAssessmentRequestCollectionRequest {

    /**
     * The request builder for this collection of ThreatAssessmentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ThreatAssessmentRequestCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThreatAssessmentRequestCollectionResponse.class, IThreatAssessmentRequestCollectionPage.class);
    }

    public void get(final ICallback<IThreatAssessmentRequestCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IThreatAssessmentRequestCollectionPage get() throws ClientException {
        final ThreatAssessmentRequestCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ThreatAssessmentRequest newThreatAssessmentRequest, final ICallback<ThreatAssessmentRequest> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ThreatAssessmentRequestRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newThreatAssessmentRequest, callback);
    }

    public ThreatAssessmentRequest post(final ThreatAssessmentRequest newThreatAssessmentRequest) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ThreatAssessmentRequestRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newThreatAssessmentRequest);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IThreatAssessmentRequestCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (ThreatAssessmentRequestCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IThreatAssessmentRequestCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (ThreatAssessmentRequestCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IThreatAssessmentRequestCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (ThreatAssessmentRequestCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IThreatAssessmentRequestCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value + ""));
        return (ThreatAssessmentRequestCollectionRequest)this;
    }

    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    public IThreatAssessmentRequestCollectionRequest skip(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$skip", value + ""));
        return (ThreatAssessmentRequestCollectionRequest)this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    public IThreatAssessmentRequestCollectionRequest skipToken(final String skipToken) {
    	addQueryOption(new QueryOption("$skiptoken", skipToken));
        return (IThreatAssessmentRequestCollectionRequest)this;
    }
    public IThreatAssessmentRequestCollectionPage buildFromResponse(final ThreatAssessmentRequestCollectionResponse response) {
        final IThreatAssessmentRequestCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ThreatAssessmentRequestCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ThreatAssessmentRequestCollectionPage page = new ThreatAssessmentRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
