// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookChartLegendFormat;
import com.microsoft.graph.requests.extensions.IWorkbookChartFillRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartFillRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartFontRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartFontRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Legend Format Request.
 */
public class WorkbookChartLegendFormatRequest extends BaseRequest implements IWorkbookChartLegendFormatRequest {
	
    /**
     * The request for the WorkbookChartLegendFormat
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartLegendFormatRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartLegendFormat.class);
    }

    /**
     * Gets the WorkbookChartLegendFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<WorkbookChartLegendFormat> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartLegendFormat from the service
     *
     * @return the WorkbookChartLegendFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookChartLegendFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<WorkbookChartLegendFormat> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChartLegendFormat with a source
     *
     * @param sourceWorkbookChartLegendFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final WorkbookChartLegendFormat sourceWorkbookChartLegendFormat, final ICallback<WorkbookChartLegendFormat> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartLegendFormat);
    }

    /**
     * Patches this WorkbookChartLegendFormat with a source
     *
     * @param sourceWorkbookChartLegendFormat the source object with updates
     * @return the updated WorkbookChartLegendFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookChartLegendFormat patch(final WorkbookChartLegendFormat sourceWorkbookChartLegendFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartLegendFormat);
    }

    /**
     * Creates a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final WorkbookChartLegendFormat newWorkbookChartLegendFormat, final ICallback<WorkbookChartLegendFormat> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartLegendFormat);
    }

    /**
     * Creates a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the new object to create
     * @return the created WorkbookChartLegendFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookChartLegendFormat post(final WorkbookChartLegendFormat newWorkbookChartLegendFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartLegendFormat);
    }

    /**
     * Creates a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final WorkbookChartLegendFormat newWorkbookChartLegendFormat, final ICallback<WorkbookChartLegendFormat> callback) {
        send(HttpMethod.PUT, callback, newWorkbookChartLegendFormat);
    }

    /**
     * Creates a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the object to create/update
     * @return the created WorkbookChartLegendFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookChartLegendFormat put(final WorkbookChartLegendFormat newWorkbookChartLegendFormat) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChartLegendFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IWorkbookChartLegendFormatRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (WorkbookChartLegendFormatRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IWorkbookChartLegendFormatRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (WorkbookChartLegendFormatRequest)this;
     }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
     public IWorkbookChartLegendFormatRequest filter(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$filter", value));
         return (WorkbookChartLegendFormatRequest)this;
     }

}

