/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests.extensions;

import com.microsoft.graph.callrecords.models.extensions.Segment;
import com.microsoft.graph.callrecords.requests.extensions.ISegmentCollectionPage;
import com.microsoft.graph.callrecords.requests.extensions.ISegmentCollectionRequest;
import com.microsoft.graph.callrecords.requests.extensions.SegmentCollectionPage;
import com.microsoft.graph.callrecords.requests.extensions.SegmentCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.extensions.SegmentCollectionResponse;
import com.microsoft.graph.callrecords.requests.extensions.SegmentRequestBuilder;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class SegmentCollectionRequest
extends BaseCollectionRequest<SegmentCollectionResponse, ISegmentCollectionPage>
implements ISegmentCollectionRequest {
    public SegmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SegmentCollectionResponse.class, ISegmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISegmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SegmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISegmentCollectionPage get() throws ClientException {
        SegmentCollectionResponse response = (SegmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Segment newSegment, ICallback<Segment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SegmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSegment, callback);
    }

    @Override
    public Segment post(Segment newSegment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SegmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSegment);
    }

    @Override
    public ISegmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISegmentCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISegmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISegmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISegmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISegmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISegmentCollectionPage buildFromResponse(SegmentCollectionResponse response) {
        SegmentCollectionRequestBuilder builder = response.nextLink != null ? new SegmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SegmentCollectionPage page = new SegmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

