/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ApplicationDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.ApplicationDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ApplicationDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IApplicationDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IApplicationDeltaCollectionRequest;
import java.util.List;

public class ApplicationDeltaCollectionRequest
extends BaseCollectionRequest<ApplicationDeltaCollectionResponse, IApplicationDeltaCollectionPage>
implements IApplicationDeltaCollectionRequest {
    public ApplicationDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApplicationDeltaCollectionResponse.class, IApplicationDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IApplicationDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ApplicationDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IApplicationDeltaCollectionPage get() throws ClientException {
        ApplicationDeltaCollectionResponse response = (ApplicationDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IApplicationDeltaCollectionPage buildFromResponse(ApplicationDeltaCollectionResponse response) {
        ApplicationDeltaCollectionRequestBuilder builder = response.nextLink != null ? new ApplicationDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ApplicationDeltaCollectionPage page = new ApplicationDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IApplicationDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IApplicationDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IApplicationDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }
}

