/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ChangeTrackedEntity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IChangeTrackedEntityRequest;
import java.util.List;

public class ChangeTrackedEntityRequest
extends BaseRequest
implements IChangeTrackedEntityRequest {
    public ChangeTrackedEntityRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends ChangeTrackedEntity> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public ChangeTrackedEntityRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChangeTrackedEntity.class);
    }

    @Override
    public void get(ICallback<ChangeTrackedEntity> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ChangeTrackedEntity get() throws ClientException {
        return (ChangeTrackedEntity)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ChangeTrackedEntity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ChangeTrackedEntity sourceChangeTrackedEntity, ICallback<ChangeTrackedEntity> callback) {
        this.send(HttpMethod.PATCH, callback, sourceChangeTrackedEntity);
    }

    @Override
    public ChangeTrackedEntity patch(ChangeTrackedEntity sourceChangeTrackedEntity) throws ClientException {
        return (ChangeTrackedEntity)this.send(HttpMethod.PATCH, sourceChangeTrackedEntity);
    }

    @Override
    public void post(ChangeTrackedEntity newChangeTrackedEntity, ICallback<ChangeTrackedEntity> callback) {
        this.send(HttpMethod.POST, callback, newChangeTrackedEntity);
    }

    @Override
    public ChangeTrackedEntity post(ChangeTrackedEntity newChangeTrackedEntity) throws ClientException {
        return (ChangeTrackedEntity)this.send(HttpMethod.POST, newChangeTrackedEntity);
    }

    @Override
    public void put(ChangeTrackedEntity newChangeTrackedEntity, ICallback<ChangeTrackedEntity> callback) {
        this.send(HttpMethod.PUT, callback, newChangeTrackedEntity);
    }

    @Override
    public ChangeTrackedEntity put(ChangeTrackedEntity newChangeTrackedEntity) throws ClientException {
        return (ChangeTrackedEntity)this.send(HttpMethod.PUT, newChangeTrackedEntity);
    }

    @Override
    public IChangeTrackedEntityRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChangeTrackedEntityRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IChangeTrackedEntityRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

