/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.CloudCommunications;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ICloudCommunicationsRequest;
import java.util.List;

public class CloudCommunicationsRequest
extends BaseRequest
implements ICloudCommunicationsRequest {
    public CloudCommunicationsRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CloudCommunications.class);
    }

    @Override
    public void get(ICallback<CloudCommunications> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public CloudCommunications get() throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<CloudCommunications> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(CloudCommunications sourceCloudCommunications, ICallback<CloudCommunications> callback) {
        this.send(HttpMethod.PATCH, callback, sourceCloudCommunications);
    }

    @Override
    public CloudCommunications patch(CloudCommunications sourceCloudCommunications) throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.PATCH, sourceCloudCommunications);
    }

    @Override
    public void post(CloudCommunications newCloudCommunications, ICallback<CloudCommunications> callback) {
        this.send(HttpMethod.POST, callback, newCloudCommunications);
    }

    @Override
    public CloudCommunications post(CloudCommunications newCloudCommunications) throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.POST, newCloudCommunications);
    }

    @Override
    public void put(CloudCommunications newCloudCommunications, ICallback<CloudCommunications> callback) {
        this.send(HttpMethod.PUT, callback, newCloudCommunications);
    }

    @Override
    public CloudCommunications put(CloudCommunications newCloudCommunications) throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.PUT, newCloudCommunications);
    }

    @Override
    public ICloudCommunicationsRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICloudCommunicationsRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public ICloudCommunicationsRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

